<?php
/*
Plugin Name: 节日装点
Plugin URI: http://www.qymao.cn/plugins/13131.html
Description: 为网站添加灯笼及花瓣飘落特效。
Author: www.qymao.cn
Author URI: http://www.qymao.cn
Version: 1.0
License: GPLv2 or later
*/
if ( ! defined( 'ABSPATH' ) ) { exit; }
// 路径
define( 'ZM_PATH', plugin_dir_path( __FILE__ ) );

// 选项
require ZM_PATH . '/assets/options.php';

// 灯笼Class
if (fe_get_option('dll') || fe_get_option('dlr') || fe_get_option('mh') || fe_get_option('hb')) {
	if (fe_get_option('mo') || ( !wp_is_mobile() ) ) {
		require ZM_PATH . '/assets/class.php';
	}
}

// 加载样式JS
function festival_scripts_style() {
	if (fe_get_option('dll') || fe_get_option('dlr') || fe_get_option('mh') || fe_get_option('hb')) {
		wp_enqueue_style( 'festival', plugins_url( '/assets/css/festival.css', __FILE__ ) );
	}

	if (fe_get_option('hb')) {
 		wp_enqueue_script( 'snowfall', plugins_url( '/assets/js/snowfall.js', __FILE__ ), array('jquery'), true, '1.0' );
	}

}

if (fe_get_option('mo') || ( !wp_is_mobile() ) ) {
	add_action( 'wp_enqueue_scripts', 'festival_scripts_style' );
}
// Settings
add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'fe_plugin_action_links');
function fe_plugin_action_links($links) {
	$links[] = '<a href="' . get_admin_url(null, 'options-general.php?page=festival_options') . '">' . __('Settings') . '</a>';
	return $links;
}

// 跳转到设置
register_activation_hook(__FILE__, 'fe_plugin_activate');
add_action('admin_init', 'fe_plugin_redirect');
function fe_plugin_activate() {
	add_option('fe_plugin_activation_redirect', true);
}
function fe_plugin_redirect() {
	if (get_option('fe_plugin_activation_redirect', false)) {
		delete_option('fe_plugin_activation_redirect');
		wp_redirect(admin_url( 'options-general.php?page=festival_options' ));
	}
}